#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSCall'
require 'aprs4r/APRSMessage'

require 'aprs4r/extensions/Extension'
require 'aprs4r/extensions/TranslatePathExtensionConfiguration'


module APRS4R

  class TranslatePathExtension < Extension

    @logger = APRS4RLogger.get_logger( "TranslatePathExtension")


    def initialize
      logger.info( "initialize")

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      return
    end


    def handle_message( name, message, repeat)
      logger.info( "handle_message( name, message, repeat)")

      return [@@RESULT_ACCEPT, nil] if message.nil? || message.path.nil?

      path = message.path

      # search for last repeated flag
      repeated_index = 0
      for i in 0...path.length
        entry = APRSCall.parse( path[i])

        repeated_index = i+1 if entry.repeated
      end

      behind_relay = false
      behind_wide1 = false

      if repeated_index > 0
        behind_relay = true 
        behind_wide1 = true 
      end

      for i in repeated_index...path.length
        entry = path[i]
        call = nil

        if entry == "RELAY"
          if behind_relay
            call = APRSCall.parse( "WIDE2-1")
          else
            call = APRSCall.parse( "WIDE1-1")
            behind_relay = true
            behind_wide1 = true
          end
        elsif entry == "WIDE" || entry == "TRACE"
          call = APRSCall.parse( "WIDE2-1")
        elsif entry == "WIDE1-1"
          if behind_wide1
            call = APRSCall.parse( "WIDE2-1")
          else
            bedind_wide1 = true
          end
        elsif entry =~ /TRACE[0-9]/
          call = APRSCall.parse( "WIDE" + entry[5...8])
        end

        path[i] = call.to_s if call
      end

      return [@@RESULT_ACCEPT, message]
    end

  end

end
