#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'

require 'aprs4r/extensions/ExtensionConfiguration'


module APRS4R

  class Extension < APRS4RBase

    @@RESULT_UNKNOWN  = 0x00
    @@RESULT_ACCEPT   = 0x01
    @@RESULT_DROP     = 0x02
    @@RESULT_DELAY    = 0x04


    @logger = APRS4RLogger.get_logger( "Extension")


    def initialize
      logger.info( "initialize")
      
      super

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      logger.debug( "configuration: #{configuration}")

      @name = configuration.name
      @type = configuration.type

      @enable = false
      @enable = true if configuration.enable == true 

      return
    end


    def handle_message( name, message, repeat)
      logger.info( "handle_message( name, message, repeat)")

      return @@RESULT_DROP, nil
    end


    def Extension.RESULT_ACCEPT
      return @@RESULT_ACCEPT
    end

    
    def Extension.RESULT_DROP
      return @@RESULT_DROP
    end

    
    def Extension.RESULT_DELAY
      return @@RESULT_DELAY
    end

  end

end
