#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'
require 'aprs4r/PluginConfiguration'

require 'aprs4r/extensions/ExtensionConfiguration'

require 'aprs4r/extensions/AcceptExtensionConfiguration'
require 'aprs4r/extensions/DenyExtensionConfiguration'

require 'aprs4r/extensions/RangeFilterExtensionConfiguration'

require 'aprs4r/extensions/TranslatePathExtensionConfiguration'
require 'aprs4r/extensions/OptimizePathExtensionConfiguration'
require 'aprs4r/extensions/ReducePathExtensionConfiguration'

require 'aprs4r/extensions/DigipeaterExtensionConfiguration'


module APRS4R

  class SmartDigipeaterPluginConfiguration < PluginConfiguration

    attr_accessor :device, :extensions


    def to_yaml_properties
      return super + %w{@device @extensions}
    end

    def attributes
      
      attributes = [ 
                    ConfigurationAttribute.new( "device",        "text",    true, 10, "rf0",      "Schnittstelle"),
                    ConfigurationAttribute.new( "extensions",    "array",   true, 20, Array.new,  "Erweiterungen"),
                   ]

      return super + attributes
    end

  end

end
