#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2009 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'thread'

require 'aprs4r/APRS4RLogger'

require 'aprs4r/TelemetryData'
require 'aprs4r/TelemetryPlugin'
require 'aprs4r/SampleTelemetryPluginConfiguration'


module APRS4R

  class SampleTelemetryPlugin < TelemetryPlugin

    @logger = APRS4RLogger.get_logger( "SampleTelemetryPlugin")


    def initialize
      logger.info( "initialize")

      super

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)


      @sequence = 0

      @dataset_id = 0
      @dataset_id = configuration.dataset_id if configuration.dataset_id

      @analog_values = Array.new( 8, 0)
      @analog_values = configuration.analog_values if configuration.analog_values
      
      @digital_values = Array.new( 8, 0)
      @digital_values = configuration.digital_values if configuration.digital_values

      @comment = ""
      @comment = configuration.comment if configuration.comment

      @period = 300
      @period = configuration.period if configuration.period

      return
    end

    
    def start
      logger.info( "start")

      Thread.new { runSampleThread }

      return
    end


    def runSampleThread
      logger.info( "runSampleThread")

      while true 
        
        dataset = TelemetryData.new( @sequence, @analog_values, @digital_values, @comment)

        logger.debug( "id: #{@dataset_id}, dataset: #{dataset}")
        
        set_dataset( @dataset_id, dataset)
        
        sleep @period

        @sequence += 1
      end

      return
    end

  end

end
