#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@friggleware.de> and
#                        Andreas Bier <dl1hrc@web.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'socket'
require 'thread'
require 'timeout'
require 'io/nonblock'

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSCall'
require 'aprs4r/Socket'


module APRS4R

  class SampleSocket < Socket

    @logger = APRS4RLogger.get_logger( "SampleSocket")


    def initialize
      logger.info( "initialize")

      super

      return
    end

    
    def setup( configuration)
      logger.info( "setup( configuration)")
      
      super( configuration)
      
      return
    end
    
    
    def init_socket
      logger.info( "init_socket")
      
      if ! @enable 
        return
      end

      return
    end
    
    
    def read_data
      logger.info( "read_data")

      sleep

      return nil
    end
    

    def parse_message( data)
      logger.info( "parse_message( data)")
      
      logger.debug( "data: #{data}")

      if data.nil?
        return nil
      end

      return nil
    end

    
    def serialize_message( message)
      logger.info( "serialize_message( message)")

      return nil if message.nil?

      return nil
    end


    def write_data( data)
      logger.info( "write_wata( data)")

      return if data.nil?

      return
    end

  end

end
