#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/Plugin'


module APRS4R

  class MemoryPlugin < Plugin

    @logger = APRS4RLogger.get_logger( "MemoryPlugin")


    def initialize
      logger.info( "initialize")

      super

      return
    end

    
    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      @delay = 60
      @delay = configuration.delay.to_i if configuration.delay

      return
    end

    
    def start
      logger.info( "start")

      if ! @enable
        return
      end

      Thread.new{ run_profiler_thread } 

      return
    end


    def stop
      logger.info( "stop")

      if ! @enable
        return
      end

      return
    end


    def run_profiler_thread
      logger.info( "run_profiler_thread")

      run = true
      while run 
        
        begin
          GC.start

          size_method = "size"

          objects = 0

          others = Hash.new( 0)
          others_size = Hash.new( 0)

          aprs4r = Hash.new( 0)

          aprs4r_plugins = Array.new

          ObjectSpace.each_object { |element|

            objects += 1
            element_class = element.class.to_s

            if element_class !~ /^APRS4R\:\:/
              others[element.class] += 1

              if element.class == String || element.class == Hash || element.class == Array
                others_size[element.class] += element.size 
              end

            else
              aprs4r[element.class] += 1

              aprs4r_plugins << element if element_class =~ /^APRS4R\:\:.*Plugin$/
            end
          }

          others_top = others.sort{ |a,b| a[1] <=> b[1] }.reverse
          aprs4r_top = aprs4r.sort{ |a,b| a[1] <=> b[1] }.reverse
          
          logger.debug( "=========================================================================")
          logger.debug( "memory dump at #{Time.now}, #{objects} objects total")

          logger.debug( "others: #{others.size} classes")
          others_top[0...10].each{ |element|
            logger.debug( "class: #{element[0]} instances: #{element[1]} size: #{others_size[element[0]]}") if element
          }

          logger.debug( "-------------------------------------------------------------------------")

          logger.debug( "aprs4r: #{aprs4r.size} classes")
          aprs4r_top[0...20].each{ |element|
            logger.debug( "class: #{element[0]} instances: #{element[1]}") if element
          }

          logger.debug( "-------------------------------------------------------------------------")

          logger.debug( "aprs4r_plugin: #{aprs4r_plugins.size} plugins")
          aprs4r_plugins.each{ |plugin|
            logger.debug( "---------------------------------")
            logger.debug( "plugin: #{plugin.class}")
            # logger.debug( "attributes: #{plugin.instance_variables.join( ', ')}")

            plugin.instance_variables.each{ |name|
              attribute = plugin.instance_variable_get( name)
              
              if attribute.is_a?( Hash) || attribute.is_a?( Array)
                logger.debug( "name: #{name}, size: #{attribute.size}")
              end
            }
          }

        rescue Exception => ex
          logger.warn( "gc: " + ex)
        end

        sleep @delay

      end

    end

  end

end
