#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/LogPluginConfiguration'
require 'aprs4r/Plugin'


module APRS4R

  class LogPlugin < Plugin

    @logger = APRS4RLogger.get_logger( "LogPlugin")


    def initialize
      logger.info( "initialize")

      super

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      @device = configuration.device
      @file = File.new( configuration.file, "a")

      return
    end


    def start
      logger.info( "start")

      return if !@enable

      register_listener

      return
    end

    
    def stop
      logger.info( "stop")

      return if !@enable

      unregister_listener

      return
    end


    def register_listener
      logger.info( "register_listener")

      if @enable
        @socket_manager.add_listener( @device, self)
      end

      return
    end


    def unregister_listener
      logger.info( "unregister_listener")

      if @enable
        @socket_manager.remove_listener( @device, self)
      end

      return
    end


    def recv_message( name, message)
      logger.info( "recv_message( name, message)")

      if name.nil? || message.nil? 
        logger.warn( "bogus message received")
        return
      end

      now = Time.now
      timestamp = sprintf( "%4.4i-%2.2i-%2.2i-%2.2i-%2.2i-%2.2i", now.year, now.month, now.day, now.hour, now.min, now.sec)

      source = message.source
      destination = message.destination 

      path = String.new

      if message.path
        message.path.each{ |entry|
          path += entry + "/"
        }
      end

      symbol_table = message.symbol_table
      symbol_code = message.symbol_code

      latitude = message.latitude
      longitude = message.longitude

      payload = message.payload

      line = sprintf( "%s|%s|%s|%s|%s|%s|%f|%f|%s", 
                      timestamp, 
                      source, destination, path, 
                      symbol_table, symbol_code, 
                      latitude, longitude,
                      payload) 

      @file.puts( line)
      @file.flush

      return
    end

  end

end
