#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/Plugin'
require 'aprs4r/LCDStatusPluginConfiguration'


module APRS4R

  class LCDStatusPlugin < Plugin

    @logger = APRS4RLogger.get_logger( "LCDStatusPlugin")


    def initialize
      logger.info( "initialize")

      super

      @thread_run = false
      @thread = nil

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      @port = 1234 
      @port = configuration.port if configuration.port

      return
    end

    
    def start
      logger.info( "start")

      return if !@enable

      @thread_run = true
      @thread = Thread.new{ run }

      return
    end

    
    def stop
      logger.info( "stop")

      return if !@enable

      return
    end


    def run
      logger.info( "run")

      server = TCPServer.open( @port)

      loop do 
        socket = server.accept
        
        command = socket.gets
        command.chomp! if command

        case command
          when "line1"
          socket.puts( sprintf( "APRS4R-%5s", APRS4R::APRS4RVersion))
          when "line2"
          socket.puts( sprintf( "%3.3s in %4.4s out %4.4s", "rf0", @socket_manager.recv_count( "rf0"), @socket_manager.send_count( "rf0")))
          when "line3"
          socket.puts( sprintf( "%3.3s in %4.4s out %4.4s", "is0", @socket_manager.recv_count( "is0"), @socket_manager.send_count( "is0")))

          when "line4"
          socket.puts( @socket_manager.lastMessage)
        else
          socket.puts( "unknown query")
        end

        socket.close
      end

      return
    end
    
  end

end
