#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/BeaconPlugin'
require 'aprs4r/APRSCall'
require 'aprs4r/ExternalBeaconPluginConfiguration'


module APRS4R

  class ExternalBeaconPlugin < BeaconPlugin

    @logger = APRS4RLogger.get_logger( "ExternalBeaconPlugin")


    def initialize
      logger.info( "initialize")

      super

      return
    end


    def setup( configuration)
      logger.info( "setup")

      super( configuration)

      @host = "localhost"
      @port = 10000

      begin
        @host = configuration.host if configuration.host
        @port = configuration.port.to_i if configuration.port
      rescue Exception => ex
        logger.warn( "parameter error: #{ex}")
      end

      return
    end


    def start 
      logger.info( "start")

      return if !@enable

      @thread_run = true
      @thread = Thread.new { run }

      return
    end


    def stop
      logger.info( "stop")

      return if !@enable

      @thread_run = false

      @server.close

      return
    end


    def run
      logger.info( "run")

      @server = TCPServer.new( @host, @port)

      while @thread_run
        begin

          socket = @server.accept
          
          payload = socket.gets

          if payload 

            payload.chop!

            message = @message.clone
            message.payload = payload

            if message
              logger.log( "sending beacon on device #{@device}: #{message}")
              @socket_manager.send_message( @device, message)
              
              # attention: use this call with caution
              @socket_manager.send_local_message( @device, message)
            end

          end
            
          socket.close

          # DOS prevention
          sleep 5
            
        rescue Exception => ex
          logger.warn( "runBeaconThread: #{ex}")
        end
      end
      
    end

  end
  
end
