#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'
require 'aprs4r/PluginConfiguration'


module APRS4R

  class DigipeaterPluginConfiguration < PluginConfiguration

    attr_reader :device, :call, :mode, :aliases, :state, :rfonly, :translatePath, :reducePath, :permittedHops
    attr_writer :device, :call, :mode, :aliases, :state, :rfonly, :translatePath, :reducePath, :permittedHops


    def to_yaml_properties
      return super + %w{@device @call @mode @aliases @rfonly @translatePath @reducePath @permittedHops}
    end

    def attributes
      
      attributes = [ 
                    ConfigurationAttribute.new( "device",        "text",    true, 10, "rf0",      "Schnittstelle"),
                    ConfigurationAttribute.new( "call",          "text",    true, 10, "MYCALL",   "Rufzeichen"),
                    ConfigurationAttribute.new( "mode",          "text",    true, 10, "fillin",   "Modus"),
                    ConfigurationAttribute.new( "aliases",       "array",   true, 20, ["MYCALL"], "Aliase"),
                    ConfigurationAttribute.new( "state",         "text",    true, 4,  "DEBW",     "Bundesland"),
                    ConfigurationAttribute.new( "rfonly",        "boolean", true, 10, true,       "RFONLY"),
                    ConfigurationAttribute.new( "translatePath", "boolean", true, 10, true,       "Pfadumsetzung"),
                    ConfigurationAttribute.new( "reducePath",    "boolean", true, 10, true,       "Pfadkuerzung"),
                    ConfigurationAttribute.new( "permittedHops", "number",  true,  6, 4,          "Hops"),
                   ]

      return super + attributes
    end

  end

end
