#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'
require 'aprs4r/GatewayPluginConfiguration'


module APRS4R

  class BuddyGatewayPluginConfiguration < GatewayPluginConfiguration

    attr_reader :buddies, :timeout
    attr_writer :buddies, :timeout


    def initialize( call = nil, inDevice = nil, outDevice = nil, path = [], buddies = [], timeout = nil)
      super( call, inDevice, outDevice, true, path)

      @buddies = buddies
      @timeout = timeout

      return
    end


    def to_yaml_properties
      return super + %w{@buddies @timeout}
    end


    def attributes
      
      attributes = [ 
                    ConfigurationAttribute.new( "buddies",   "array",  true, 20, [""], "Buddies"),
                    ConfigurationAttribute.new( "timeout",   "number", true,  6, 12 * 60 * 60, "Stationstimeout")
                   ]

      return super + attributes
    end

  end

end
