#!/bin/sh

echo "APRS4R update script"

IPKG=/usr/bin/ipkg
IPKG_CONF=/etc/ipkg.conf

OPKG=/bin/opkg
OPKG_CONF=/etc/opkg.conf

PKG=/bin/false
PKG_CONF=/dev/null

echo ""
echo "Looking for package manager..."
echo ""

if [ -x $IPKG ]; then
	echo "$IPKG found..."
	PKG=$IPKG
	PKG_CONF=$IPKG_CONF
elif [ -x $OPKG ]; then 
	echo "$OPKG found..."
	PKG=$OPKG
	PKG_CONF=$OPKG_CONF
else 
	echo "no package manager found..."
	exit 1
fi

echo ""
echo "searching for installed APRS4R software..."
echo ""

# aprs4r 
APRS4R_INSTALLED="false"
$PKG status aprs4r |grep Status |grep " installed"
if [ $? == 0 ]; then
    APRS4R_INSTALLED="true"
    echo "\taprs4r found"
fi

# aprs4r-web
APRS4R_WEB_INSTALLED="false"
$PKG status aprs4r-web |grep Status |grep " installed"
if [ $? == 0 ]; then
    APRS4R_WEB_INSTALLED="true"
    echo "\taprs4r-web found"
fi

# aprs4web
APRS4WEB_INSTALLED="false"
$PKG status aprs4web |grep Status |grep " installed"
if [ $? == 0 ]; then
    APRS4WEB_INSTALLED="true"
    echo "\taprs4web found"
fi


echo ""
echo "Updating package descriptions..."
echo "" 

$PKG update

echo ""
echo "Removing APRS4R packages..."
echo ""

# aprs4web
if [ $APRS4WEB_INSTALLED == "true" ]; then
    $PKG remove aprs4web
    echo "\taprs4web removed"
fi

# aprs4r-web
if [ $APRS4R_WEB_INSTALLED == "true" ]; then
    $PKG remove aprs4r-web
    echo "\taprs4r-web removed"
fi

# aprs4r
if [ $APRS4R_INSTALLED == "true" ]; then
    $PKG remove aprs4r
    echo "\taprs4r removed"
fi


echo ""
echo "Reinstalling APRS4R packages..."
echo ""

# aprs4r
if [ $APRS4R_INSTALLED == "true" ]; then
    $PKG install aprs4r
    echo "\taprs4r installed"
fi

# aprs4r-web
if [ $APRS4R_WEB_INSTALLED == "true" ]; then
    $PKG install aprs4r-web
    echo "\taprs4r-web installed"
fi

# aprs4web
if [ $APRS4WEB_INSTALLED == "true" ]; then
    $PKG install aprs4web
    echo "\taprs4web installed"
fi

echo ""
echo "Update (hopefully) complete..."
echo ""
