#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2009 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"
print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'
APRS4R::APRS4RLogger::load_yaml_file( log4r_file)


require 'aprs4r/UltimeterWeatherMessage'


module APRS4R

  class UltimeterWeatherMessageTest < Test::Unit::TestCase

    @@logger = APRS4RLogger.get_logger( "UltimeterWeatherMessageTest")

    @@full_payload1 = "&CR&0017009A006700F0014D014D0000283D00029E7300010283------------0032050A006C002FFFF401BD0031FFF401BD00C20006006001BE0031006001BE283500000000009A280C003C002F27E204BC0213020001FD01D1003101FD01D103F2000003F20000000003F2000003F2000003F20000000003F2000000D3019200E6022B002F015604CA017303530000009A014003C2003201730353284701EB2836059B0032284701EB02A0000002A00586002F032404BE0000000000000000000000000000000000000000000000000000000000000000008700010000927E1F000035"

    @@full_payload2 = "&CR&000000AB008A00A7014B014B0000283C00009E730001028B------------00320516006C002FFFF401BD0031FFF401BD00C20006006001BE0031006001BE28350000000000AB280C003C002F27E204BC0213020001FD01D1003101FD01D103F2000003F20000000003F2000003F2000003F20000000003F2000000D3019200E6022B002F015604CA01730353000000AB014003C2003201730353284701EB2836059B0032284701EB02A0000002A00586002F032404BE0000000000000000000000000000000000000000000000000000000000000000008700010000927E1F000030"

    @@full_message1 = UltimeterWeatherMessage.new( @@full_payload1)
    @@full_message2 = UltimeterWeatherMessage.new( @@full_payload2)


    def test_is_valid
      @@logger.info( "test_is_valid")

      message1 = @@full_message1
      assert( message1.is_valid?)

      message2 = @@full_message2
      assert( message2.is_valid?)
      
    end


    def test_temperature
      @@logger.info( "test_temperature")

      message1 = @@full_message1
      @@logger.debug( "temperature1: #{message1.temperature}")
      assert( message1.has_thermo?)
      # assert_in_delta( message1.temperature, 10.6111, 0.1)

      message2 = @@full_message2
      @@logger.debug( "temperature2: #{message2.temperature}")
      assert( message2.has_thermo?)
      # assert_in_delta( message2.temperature, 2.2, 0.1)
    end

    
    def test_dewpoint
      @@logger.info( "test_dewpoint")

      message1 = @@full_message1
      @@logger.debug( "dewpoint1: #{message1.dewpoint}")
      assert( message1.has_thermo?)
      # assert_in_delta( message1.dewpoint, 10.6111, 0.1)

      message2 = @@full_message2
      @@logger.debug( "dewpoint2: #{message2.dewpoint}")
      assert( message2.has_thermo?)
      # assert_in_delta( message2.dewpoint, 2.2, 0.1)
    end

    
    def test_humidity
      @@logger.info( "test_humidity")

      message1 = @@full_message1
      @@logger.debug( "humidity1: #{message1.humidity}")
      assert( message1.has_hygro?)
      # assert_in_delta( message1.humidity, 62.2, 0.1)

      # message2 = @@full_message2
      # @@logger.debug( "humidity2: #{message2.humidity}")
      # assert( message2.has_hygro?)
      # assert_in_delta( message2.humidity, 90.0, 0.1)
    end

    
    def test_pressure_relative
      @@logger.info( "test_pressure_relative")

      message1 = @@full_message1
      @@logger.debug( "pressure_relative1: #{message1.pressure_relative}")
      assert( message1.has_baro?)
      # assert_in_delta( message1.pressure_relative, 1018.3, 0.1)

      message2 = @@full_message2
      @@logger.debug( "pressure_relative2: #{message2.pressure_relative}")
      assert( message2.has_baro?)
      # assert_in_delta( message2.pressure_relative, 990.3, 0.1)
    end


    def test_wind_direction
      @@logger.info( "test_wind_direction")

      message1 = @@full_message1
      @@logger.debug( "wind_direction1: #{message1.wind_direction}")
      assert( message1.has_wind?)
      # assert_in_delta( message1.wind_direction, 0.0, 0.1)

      message2 = @@full_message2
      @@logger.debug( "wind_direction2: #{message2.wind_direction}")
      assert( message2.has_wind?)
      # assert_in_delta( message2.wind_direction, 210.35, 1.0)
    end


    def test_wind_avg
      @@logger.info( "test_wind_avg")

      message1 = @@full_message1
      @@logger.debug( "wind_avg1: #{message1.wind_avg}")
      assert( message1.has_wind?)
      # assert_in_delta( message1.wind_avg, 0.0, 0.1)

      message2 = @@full_message2
      @@logger.debug( "wind_avg2: #{message2.wind_avg}")
      assert( message2.has_wind?)
      # assert_in_delta( message2.wind_avg, 5.35, 0.1)
    end


    def test_wind_gust
      @@logger.info( "test_wind_gust")

      message1 = @@full_message1
      @@logger.debug( "wind_gust1: #{message1.wind_gust}")
      assert( message1.has_wind?)
      # assert_in_delta( message1.wind_gust, 0.0, 0.1)

      message2 = @@full_message2
      @@logger.debug( "wind_gust2: #{message2.wind_gust}")
      assert( message2.has_wind?)
      # assert_in_delta( message2.wind_gust, 14.712, 0.1)
    end

    
    def _test_rain_today
      @@logger.info( "test_rain_today")

      message1 = @@full_message1
      @@logger.debug( "rain_today1: #{message1.rain_today}")
      assert( message1.has_rain?)
      # assert_in_delta( message1.rain_24h, 0.001016, 0.000001)

      message2 = @@full_message2
      @@logger.debug( "rain_today2: #{message2.rain_today}")
      assert( message2.has_rain?)
      # assert_in_delta( message2.rain_24h, 0.0028, 0.0001)
    end

  end

end

