#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/extensions/ExtensionConfiguration'


module APRS4R

  class RangeFilterExtensionConfiguration < ExtensionConfiguration 

    attr_accessor :latitude, :longitude, :distance

    def to_yaml_properties 
      return super + %w{@latitude @longitude @distance}
    end

    
    def attributes

      attributes = [
                    ConfigurationAttribute.new( "latitude",  "float",  true,  8, 49.000,  "Breite"),
                    ConfigurationAttribute.new( "longitude", "float",  true,  8, 8.2500,  "Laenge"),
                    ConfigurationAttribute.new( "distance",  "float",  true,  8, 50.0,    "Distanz"),
                   ]

      return super + attributes
    end
    
  end

end
