#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSMessage'

require 'aprs4r/extensions/Extension'
require 'aprs4r/extensions/RangeFilterExtensionConfiguration'


module APRS4R

  class RangeFilterExtension < Extension

    @logger = APRS4RLogger.get_logger( "RangeFilterExtension")


    def initialize
      logger.info( "initialize")

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)
      
      @latitude = nil
      @longitude = nil
      @distance = nil

      begin
        @latitude = configuration.latitude.to_f if configuration.latitude
        @longitude = configuration.longitude.to_f if configuration.longitude

        @distance = configuration.distance.to_f if configuration.distance
      rescue Exception => ex
        logger.warn( "error converting parameter: #{ex}")
      end
      
      return
    end


    def handle_message( name, message, repeat)
      logger.info( "handle_message( name, message, repeat)")

      return [@@RESULT_ACCEPT, nil] if message.nil? 

      distance = message.distance( @latitude, @longitude)

      return [@@RESULT_ACCEPT, message] if distance.nil?

      return [@@RESULT_ACCEPT, message] if distance <= @distance 

      return [@@RESULT_DROP, message]
    end

  end

end
