#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'thread'

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'


module APRS4R

  class SocketSendThread < APRS4RBase

    @logger = APRS4RLogger.get_logger( "SocketSendThread");

    @@QUEUE_MAX_LENGTH = 10


    def initialize( socket)
      logger.info( "initialize( socket)")

      @socket = socket
      @name = socket.name
      @enable = socket.enable

      @queue = Queue.new

      return
    end

    
    def send_message( name, message)
      logger.info( "send_message( name, message)")

      @queue.push( message)
      logger.debug( "after push")

      if @queue.length > @@QUEUE_MAX_LENGTH
        logger.debug( "queue overrun")
        begin
          @queue.pop( true)
          logger.debug( "first entry removed from queue")
        rescue Exception => ex
          logger.warn( "queue error: #{ex}")
        end
      end

      return
    end


    def run
      logger.info( "run")
      
      if !@enable 
        return
      end

      @socket.delayed_initialize

      while true

        # get first element (or wait until at least one message is present)
        message = @queue.pop
        logger.debug( "after pop")

        if message 
          logger.log( "message send on #{@name}: #{message}")
          # write message
          @socket.write_message( message)
          logger.debug( "after socket write")
        end

      end

      return
    end

  end

end
