#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'


module APRS4R

  class Configuration

    attr_reader :name, :type, :enable, :remote, :changed, :deprecated
    attr_writer :name, :type, :enable, :remote, :changed, :deprecated

    
    def initialize
      @enable = false if @enable.nil?
      @remote = false if @remote.nil?
      @changed = false
      @deprecated = false
    end


    def to_yaml_properties
      return %w{@name @type @enable @remote @deprecated}
    end

    
    def update_configuration( old_version, new_version)
      
      # place holder

      return
    end


    def online_url
      return "http://www.aprs4r.org/cgi-bin/trac.cgi/wiki/APRS4RDocumentationGerman"
    end


    def attributes

      attributes = [ 
                    ConfigurationAttribute.new( "name",    "text",    true,  10, nil,   "Name"), 
                    ConfigurationAttribute.new( "type",    "text",    false, 10, nil,   "Typ", online_url), 
                    ConfigurationAttribute.new( "enable",  "boolean", true,  10, false, "aktiviert"),
                    ConfigurationAttribute.new( "remote",  "boolean", true,  10, false, "fernwartbar")
                   ]

      return attributes
    end


    def attribute_type( name)
      
      type = nil

      attributes.each{ |attribute|
        if attribute.name == name
          type = attribute.type
        end
      }

      return type
    end


    def duration_to_seconds( duration)
      seconds = 0

      return 0 if duration.nil?
          
      begin

        if duration =~ /^[0-9]+$/
          # seconds without unit
          seconds = duration.to_i

        else
          # duration with unit (day, hour, minute, second)
          matches = duration.to_s.downcase.scan( /([0-9]+)([dhms])/x)
          
          matches.each{ |match|
            
            value, unit = match
            
            case unit 
              
            when "d"
              seconds += 60 * 60 * 24 * value.to_i
              
            when "h" 
              seconds += 60 * 60 * value.to_i
              
            when "m"
              seconds += 60 * value.to_i
              
            when "s"
              seconds += value.to_i
              
            end
            
          }

        end

      rescue Exception => ex
        
      end

      return seconds
    end
      
  end

end
