#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#


require 'aprs4r/SocketConfiguration'
require 'aprs4r/ConfigurationAttribute'

require 'aprs4r/KISSDeviceConfiguration'
require 'aprs4r/UDPDeviceConfiguration'


module APRS4R

  class AX25SocketConfiguration < SocketConfiguration

    attr_accessor :call, :mode, :duplicatePeriod, :txEnable, :parameters, :device, :port, :baudrate, :speed, :timeout


    def to_yaml_properties
      super + %w{ @call @mode @duplicatePeriod @txEnable @parameters}
    end


    def attributes
      attributes = [
                    ConfigurationAttribute.new( "call",            "text",    true, 10, "MYCALL",              "Rufzeichen"),
                    ConfigurationAttribute.new( "mode",            "text",    true, 15, "kiss/tnc2/northlink", "Modus"),
                    ConfigurationAttribute.new( "duplicatePeriod", "number",  true, 10, 15,                    "Duplikatsinterval"),
                    ConfigurationAttribute.new( "txEnable",        "boolean", true, 10, false,                 "TX-Modus"),
                    ConfigurationAttribute.new( "parameters",      "complex", true, 20, KISSDeviceConfiguration.new, "Parameter"),

                    ConfigurationAttribute.new( "device",          "text",    false, 10, "/dev/usb/tts/0",      "Geraet", nil, true),
                    ConfigurationAttribute.new( "port",            "number",  false,  6, 0,                     "Port (Multi-TNC)", nil, true),
                    ConfigurationAttribute.new( "baudrate",        "number",  false,  6, 9600,                  "Baudrate", nil, true),
                    ConfigurationAttribute.new( "speed",           "number",  false,  6, 1200,                  "Geschwindigkeit", nil, true),
                    ConfigurationAttribute.new( "timeout",         "number",  false,  6, 300,                   "Timeout", nil, true)
                   ]

      return super + attributes
    end


    # FIXME: fix update configuration handling

    
    def update_configuration( old_version, new_version) 

      update = false 


      current_version = old_version

      # init, if no version is set
      if current_version.nil? || current_version == "undefined" 
        current_version = "1.0.0"
        update = true
      end


      # update to 1.0.1, nothing to do
      current_version = "1.0.1" if current_version == "1.0.0"
      
      # update to 1.0.2, add parameter subsection
      if current_version == "1.0.1"
        printf( "AX25Socket: converting KISS settings\n")
        current_version = "1.0.2"
        update = true

        if @parameters.nil?
          kiss = KISSDeviceConfiguration.new
        
          kiss.name = "kiss port" 
          kiss.type = "KISSDevice"
          kiss.enable = @enable
        
          # use existing settings
          kiss.device = @device
          kiss.baudrate = @baudrate
          kiss.port = @port
          kiss.speed = @speed
          kiss.timeout = @timeout
        
          # use default settings
          kiss.txdelay = nil
          kiss.persistence = nil
          kiss.slottime = nil
          kiss.duplex = nil
        
          @parameters = kiss
          
          @device = nil
          @port = nil
          @baudrate = nil
          @speed = nil
          @timeout = nil
        end

      end
      

      # update to 1.0.3, nothing to do
      current_version = "1.0.3" if current_version == "1.0.2"
      

      # update to 1.0.4, add txEnable flag
      if current_version == "1.0.3"
        printf( "AX25Socket: add txEnable flag, setting to false\n")
        current_version = "1.0.4"
        update = true

        @txEnable = false if @txEnable.nil?
      end
      
      
      return update
    end

  end
  
end
