#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/server/filter/Filter'


module APRS4R

  class QFilter < Filter

    @logger = APRS4RLogger.get_logger( "QFilter")


    def initialize( digipeaters)
      logger.info( "initialize( digipeaters)")

      @digipeaters = Array.new

      if digipeaters.is_a?( Array)
        digipeaters.each{ |digipeater|
          @digipeaters << digipeater.to_s
        }
      end

      return
    end


    def match( message)
      logger.info( "match")
      
      return false if message.nil?

      path = message.path

      return false if path.nil? || path.empty?

      # TODO handle wildcard
      @digipeaters.each{ |digipeater|
        return true if path.include( digipeater)
      }
      
      return return false
    end

  end

end
