#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/DeviceConfiguration'
require 'aprs4r/ConfigurationAttribute'


module APRS4R

  class UDPDeviceConfiguration < DeviceConfiguration

    attr_accessor :local_host, :local_port, :remote_host, :remote_port


    def to_yaml_properties
      super + %w{ @local_host @local_port @remote_host @remote_port}
    end


    def attributes
      attributes = [
                    ConfigurationAttribute.new( "local_host",  "text",   true, 10, "localhost",  "lokaler Rechner"),
                    ConfigurationAttribute.new( "local_port",  "number", true,  6, 1000,         "lokale Portnummer"),
                    ConfigurationAttribute.new( "remote_host", "text",   true, 10, "remotehost", "entfernter Rechner"),
                    ConfigurationAttribute.new( "remote_port", "number", true,  6, 1000,         "entfernter Portnummer")
                   ]

      return super + attributes
    end

  end

end
