#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'
require 'aprs4r/Socket'


module APRS4R

  class TestSocket < Socket

    @logger = APRS4RLogger.get_logger( "FileSocket")


    def initialize
      logger.info( "initialize")

      super

      @recv_queue = Queue.new
      @send_queue = Queue.new

    end


    def setup( configuration)
      logger.info( "setup( configuration)")
      
      super( configuration)

      return
    end
    
    
    def init_socket
      logger.info( "init_socket")
      
      return
    end
    
    
    def read_data
      logger.info( "read_data")

      sleep 1

      message = @recv_queue.pop

      return message
    end

    
    def parse_message( data)
      logger.info( "parse_message( data)")
      
      return data
    end


    def serialize_message( message) 
      logger.info( "serialize_message( message)")
      
      return message
    end

    
    def write_data( data)
      logger.info( "write_data( data)")

      sleep 1

      @send_queue.push( data)

      return
    end


    def recv( message)
      logger.info( "recv( message)")

      @recv_queue.push( message)
    end


    def send
      logger.info( "send")

      return nil if @send_queue.empty?

      return @send_queue.pop 
    end

  end

end
