#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSMessage'
require 'aprs4r/Plugin'
require 'aprs4r/LCD4LinuxPluginConfiguration'


module APRS4R

  class LCD4LinuxPlugin < Plugin

    @logger = APRS4RLogger.get_logger( "LCD4LinuxPlugin")

    
    def initialize
      logger.info( "initialize")

      super

      @thread_run = false
      @thead = nil

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      @file = configuration.file
      @devices = configuration.devices
      
      return
    end

    
    def start
      logger.info( "start")

      return if !@enable

      @thread_run = true
      @thread = Thread.new{ run } 

      return
    end

    
    def stop
      logger.info( "stop")

      return if !@enable

      return
    end


    def run 
      logger.info( "run")

      uptime = 0
      minute = 60
      hour = 60 * minute 
      day = 24 * hour

      while @thread_run
        lines = Array.new

        line = sprintf( "APRS4R-%5s", APRS4R::APRS4RVersion)
        
        if uptime > day
          days = uptime / day
          hours = (uptime % day) / hour

          line = sprintf( "APRS4R-%5s %03id%02ih", APRS4R::APRS4RVersion, days, hours)
        else
          hours = uptime / hour 
          minutes = (uptime % hour) / minute
          
          line = sprintf( "APRS4R-%5s %03ih%02im", APRS4R::APRS4RVersion, hours, minutes)
        end

        lines << line

        if @devices
          @devices.each{ |device|

            recv_count = @socket_manager.recv_count( device) || "xxxx"
            send_count = @socket_manager.send_count( device) || "xxxx"
            
            line = sprintf( "%3.3s in %4.4s out %4.4s", device, recv_count, send_count)
            
            lines << line
          }
        end
        
        message = @socket_manager.lastMessage

        if message
          lines << message.to_s
        end

        file = File.new( @file, "w")
        lines.each{ |line|
          file.puts( line)
        }
        file.close

        uptime += 30
        sleep 30

      end

    end

  end

end
