#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/DeviceConfiguration'
require 'aprs4r/ConfigurationAttribute'


module APRS4R

  class KISSDeviceConfiguration < DeviceConfiguration

    attr_accessor :device, :baudrate, :port, :speed, :timeout, :txdelay, :persistence, :slottime, :duplex

    KISS_DEFAULT_DEVICE = "/dev/usb/tts/0"
    KISS_DEFAULT_BAUDRATE = 9600
    KISS_DEFAULT_PORT = 0
    KISS_DEFAULT_SPEED = 1200
    KISS_DEFAULT_TIMEOUT = 300

    KISS_DEFAULT_TXDELAY = 50
    KISS_DEFAULT_PERSISTENCE = 63
    KISS_DEFAULT_SLOTTIME = 10
    KISS_DEFAULT_DUPLEX = false 

    def to_yaml_properties
      super + %w{ @device @baudrate @port @speed @timeout @txdelay @persistence @slottime @duplex}
    end


    def attributes
      attributes = [
                    ConfigurationAttribute.new( "device",      "text",    true, 10, "/dev/usb/tts/0", "Geraet"),
                    ConfigurationAttribute.new( "baudrate",    "number",  true,  6, 9600,             "Baudrate"),
                    ConfigurationAttribute.new( "port",        "number",  true,  6, 0,                "Port (Multi-TNC)"),
                    ConfigurationAttribute.new( "speed",       "number",  true,  6, 1200,             "Geschwindigkeit"),
                    ConfigurationAttribute.new( "timeout",     "number",  true,  6, 300,              "Timeout"),
                    ConfigurationAttribute.new( "txdelay",     "number",  true,  6, KISS_DEFAULT_TXDELAY, "TX-Delay (optional, in 10ms Schritten)"),
                    ConfigurationAttribute.new( "persistence", "number",  true,  6, KISS_DEFAULT_PERSISTENCE, "Persistenz (optional, 0-255)"),
                    ConfigurationAttribute.new( "slottime",    "number",  true,  6, KISS_DEFAULT_SLOTTIME, "Slot-Time (optional, in 10ms Schritten)"),
                    ConfigurationAttribute.new( "duplex",      "boolean", true,  6, KISS_DEFAULT_DUPLEX, "Duplex (optional, ja=duplex, nein=halbduplex")
                   ]

      return super + attributes
    end

  end

end
