#!/bin/sh

APT=/usr/bin/apt-get

check_and_update()
{
    package=$1

    echo -n "Checking system for package: $package "

    dpkg-query -s $package 2> /dev/null|grep -q "Status: install ok installed"

    if [ "$?" == "0" ]; then
	echo "installed."
	echo "Upgrading package $package"
	$APT install $package
    else
	echo "not installed, skiping package. "
    fi

}

echo "Updating package descriptions..."
$APT update

# update aprs4r 
check_and_update "aprs4r"

# update aprs4r web interface
check_and_update "aprs4r-web"

# update aprs4web
check_and_update "aprs4web"

