#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

require 'aprs4r/WMRWeatherMessage'


module APRS4R

  class WMRWeatherMessageTest < Test::Unit::TestCase


    def test_thermo_sign_minus
      
      type = 0x04
      payload = String.new

      payload << 0x00
      payload << 0x34
      payload << 0x82

      checksum = 0x00

      message = WMRWeatherMessage.new( type, payload, checksum)

      assert( message.has_thermo?)

      p message.temperature
      
      
    end
    
    def test_thermo_sign_plus
      
      type = 0x04
      payload = String.new

      payload << 0x00
      payload << 0x34
      payload << 0x42

      checksum = 0x00

      message = WMRWeatherMessage.new( type, payload, checksum)

      assert( message.has_thermo?)

      p message.temperature
      
      
    end

  end

end

