#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"
print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'
APRS4R::APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/SpeechPlugin'
require 'aprs4r/SpeechPluginConfiguration'


module APRS4R

  class SpeechPluginTest < Test::Unit::TestCase

    @@logger = APRS4RLogger.get_logger( "SpeechPluginTest")

    def setup
      @@logger.info( "setup")

      configuration = SpeechPluginConfiguration.new
      configuration.period = 60
      configuration.offset = 5
      configuration.text = "Hallo Du Du"
      configuration.command = "/usr/bin/play"
      configuration.path = "/opt/sound"
      
      @plugin = SpeechPlugin.new( configuration)
    end


    def test_create_text

      text = @plugin.create_text
      @@logger.debug( "text: #{text}")

      assert( text)
    end

    
    def test_create_words
      
      words = @plugin.create_words( "This is a Test")
      @@logger.debug( "words: #{words}")

      assert( words)
    end


    def test_create_words_int

      words = @plugin.create_words( "1234")
      @@logger.debug( "words: #{words}")

      assert( words)
    end


    def test_create_words_int_negative

      words = @plugin.create_words( "-5678")
      @@logger.debug( "words: #{words}")

      assert( words)
    end


    def test_create_words_float

      words = @plugin.create_words( "1.234")
      @@logger.debug( "words: #{words}")

      assert( words)
    end


    def test_create_words_float_negative

      words = @plugin.create_words( "-5.678")
      @@logger.debug( "words: #{words}")

      assert( words)
    end


    def test_play_words
      
      words = @plugin.create_words( "Wind 1.45 Temperatur 15.6 Grad")
      assert( words)

      @plugin.play_words( words)

    end

  end

end
  
