#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RTest'

require 'aprs4r/APRSMessage'
require 'aprs4r/SmartDigipeaterPlugin'
require 'aprs4r/SmartDigipeaterPluginConfiguration'


module APRS4R

  class SmartDigipeaterPluginTest < APRS4RTest

    @logger = APRS4RLogger.get_logger( "SmartDigipeaterPluginTest")

  
    def test_accept
      
      configuration = SmartDigipeaterPluginConfiguration.new
      
      configuration.name = "smart"
      configuration.type = "SmartDigipeaterPlugin"
      configuration.enable = true 
      
      configuration.device = "test0"
      
      accept = AcceptExtensionConfiguration.new
      accept.name = "accept"
      accept.type = "AcceptExtension"
      accept.enable = "true"
      
      configuration.extensions = [ accept ]
      
      @plugin = SmartDigipeaterPlugin.new
      @plugin.setup( configuration)
      
      
      message1 = APRSMessage.new( "FROM", "TO", [], ">accept test")
      record1 = ["test0", message1, 0, false]
      
      message2 = APRSMessage.new( "FROM", "TO", [], ">accept test")
      record2 = ["test0", message2, 0, false]
      
      result1 = @plugin.handle_record( record1)
      assert( result1)
      assert_equal( message1, result1)
      
      result2 = @plugin.handle_record( record2)
      assert( result2)
      assert_equal( message2, result2)
      
    end
    
    
    def test_deny
      
      configuration = SmartDigipeaterPluginConfiguration.new
      
      configuration.name = "smart"
      configuration.type = "SmartDigipeaterPlugin"
      configuration.enable = true 
      
      configuration.device = "test0"
      
      deny = DenyExtensionConfiguration.new
      deny.name = "deny"
      deny.type = "DenyExtension"
      deny.enable = "true"
      
      configuration.extensions = [ deny ]
      
      @plugin = SmartDigipeaterPlugin.new
      @plugin.setup( configuration)
      
      
      message1 = APRSMessage.new( "FROM", "TO", [], ">deny test")
      record1 = ["test0", message1, 0, false]
      
      message2 = APRSMessage.new( "FROM", "TO", [], ">deny test")
      record2 = ["test0", message2, 0, false]
      
      result1 = @plugin.handle_record( record1)
      assert_nil( result1)
      
      result2 = @plugin.handle_record( record2)
      assert_nil( result2)
      
    end
    
  end

end
  
