#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"
print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'
APRS4R::APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/APRSMessage'
require 'aprs4r/MessagePlugin'
require 'aprs4r/MessagePluginConfiguration'


module APRS4R

  class MessagePluginTest < Test::Unit::TestCase

    @@logger = APRS4RLogger.get_logger( "MessagePluginTest")

    def setup
      @@logger.info( "setup")

      @rfName = "test-rf0"
      @isName = "test-is0"
      
      configuration = MessagePluginConfiguration.new
      
      configuration.rfDevice = @rfName
      configuration.isDevice = @isName
      configuration.timeout = 2
      
      @plugin = MessagePlugin.new
      @plugin.setup( configuration)
    end
    
    
    def test_no_message
      
      message = APRSMessage.new( "FROM", "TO", [], ">This is no message")
      
      result = @plugin.receive_is_message( message)

      assert_nil( result)

      return
    end


    def test_no_user
      
      message = APRSMessage.new( "FROM", "XYZ", [], ":TO       :This is a test message")

      result = @plugin.receive_is_message( message)

      assert_nil( result)

      return
    end

    
    def test_user_unknown

      message1 = APRSMessage.new( "USER1", "XYZ", [], ":Message1")
      message2 = APRSMessage.new( "USER2", "XYZ", [], ":Message1")
      message3 = APRSMessage.new( "USER3", "XYZ", [], ":Message1")
      message4 = APRSMessage.new( "USER4", "XYZ", [], ":Message1")

      @plugin.receive_rf_message( message1)
      @plugin.receive_rf_message( message2)
      @plugin.receive_rf_message( message3)
      @plugin.receive_rf_message( message4)

      message = APRSMessage.new( "FROM", "XYZ", [], ":TO       :Test is a test message")

      result = @plugin.receive_is_message( message)

      assert_nil( result)

      return
    end


    def test_user_known_no_path
      @@logger.info( "test_user_known_no_path")

      message1 = APRSMessage.new( "TO", "XYZ", [], ">I'am here")
      @plugin.receive_rf_message( message1)

      message = APRSMessage.new( "FROM", "XYZ", [], ":TO       :Test is a test message")

      # user is in area
      result = @plugin.receive_is_message( message)
      assert( result)

      sleep 5

      # user is out of area (timeout)
      result = @plugin.receive_is_message( message)
      assert_nil( result)

      return
    end

    
    def test_user_known_have_path
      @@logger.info( "test_user_known_no_path")

      message1 = APRSMessage.new( "TO", "XXXX", ["MYDIGI", "WIDE1-1"], ">I'am here")
      @plugin.receive_rf_message( message1)

      message = APRSMessage.new( "FROM", "XXXX", ["DIGI1", "DIGI2*", "WIDE2-1"], ":TO       :Test is a test message")

      # user is in area
      result = @plugin.receive_is_message( message)
      assert( result)

      if result 
        @@logger.debug( "send message: #{result}")
      end

      return
    end

  end

end
  
