#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'


module APRS4R

  class TelemetryData < APRS4RBase

    include Comparable

    @logger = APRS4RLogger.get_logger( "TelemetryData")

    attr_accessor :sequence, :analog_values, :digital_values, :comment


    def initialize( sequence = 0, analog_values = Array.new( 5, 0), digital_values = Array.new( 8, 0), comment = "")
      logger.info( "initialize( sequence, analog_values, digital_values, comment)")

      @sequence = sequence
      @analog_values = analog_values
      @digital_values = digital_values
      @comment = comment
    end


    def <=>( other)
      logger.info( "<=>( other)")

      result = self.analog_values <=> other.analog_values
      return result if result != 0

      result = self.digital_values <=> other.digital_values
      return result if result != 0

      return self.comment <=> other.comment
    end


    def to_s
      logger.info( "to_s")

      buffer = String.new

      buffer << "sequence: #{@sequence}, " 
      buffer << "analog: #{@analog_values.join( ' ')}, "
      buffer << "digital: #{@digital_values.join( ' ')}, "
      buffer << "comment: #{@comment}"

      return buffer.to_s
    end

  end

end
