#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2009 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/BeaconPlugin'
require 'aprs4r/TelemetryData'
require 'aprs4r/TelemetryBeaconPluginConfiguration'


module APRS4R

  class TelemetryBeaconPlugin < BeaconPlugin

    include Comparable

    @logger = APRS4RLogger.get_logger( "TelemetryBeaconPlugin")


    def initialize
      logger.info( "initialize")

      super

      @dataset_last = TelemetryData.new
      @dataset_sent = Time.now

      return
    end

    
    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      @dataset_id = nil
      @dataset_id = configuration.dataset_id if configuration.dataset_id

      @period_max = 1800
      @period_max = configuration.period_max if configuration.period_max

      return
    end

    
    def create_beacon
      logger.info( "create_beacon")

      plugin = @plugin_manager.get_plugin( TelemetryPlugin)
      message = nil

      @dataset = nil
      @dataset = plugin.get_dataset( @dataset_id) if plugin

      logger.debug( "dataset: #{dataset}")

      if @dataset

        # return if dataset is unchanged and period_max is not reached
        return nil if (@dataset_last == @dataset) && (Time.now - @dataset_sent) < @period_max

        @dataset_last = @dataset
        @dataset_sent = Time.now

        message = @message.clone

        # message identificator and sequence number
        payload = sprintf( "T#%03i,", (@dataset.sequence % 1000))

        # analog values (comma seperated, 0-255)
        @dataset.analog_values.each{ |value|
          payload += sprintf( "%03i,", (value % 256))
        }

        # digital values (1 bit per char "0"/"1")
        @dataset.digital_values.each{ |value|
          if value != 0 
            payload += "1"
          else
            payload += "0"
          end
        }

        # optional comment
        payload += @dataset.comment

        message.payload = payload 
      end

      return message
    end

  end
  
end
