#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSMessage'
require 'aprs4r/Plugin'
require 'aprs4r/PositionPluginConfiguration'


module APRS4R
  
  class PositionPlugin < Plugin
    
    # latitude and longitude are in decimal wgs 84, course in decimal degree, speed in meter per second
    attr_accessor :latitude, :longitude, :course, :speed

    @logger = APRS4RLogger.get_logger( "PositionPlugin")

    
    def initialize
      logger.info( "initialize")

      super

      return
    end

    
    def setup( configuration)
      logger.info( "setup( configuration)")
      
      super( configuration)
      
      return
    end
    
    
  end

end
