#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2009 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/Plugin'
require 'aprs4r/GreetingPluginConfiguration'


module APRS4R

  class GreetingPlugin < Plugin

    @logger = APRS4RLogger.get_logger( "GreetingPlugin")


    def initialize
      logger.info( "initialize")

      super

      @user_calls = Hash.new

      return
    end


    def setup( configuration)
      logger.info( "setup( configuration)")

      super( configuration)

      @device = configuration.device
      @timeout = configuration.timeout

      @message = configuration.message


      return
    end

    
    def start
      logger.info( "start")

      return if !@enable

      register_listener

      return
    end

    
    def stop
      logger.info( "stop")

      return if !@enable

      unregister_listener

      return
    end

    
    def register_listener
      logger.info( "register_listener")

      return if !@enable

      @socket_manager.add_listener( @device, self)

      return
    end


    def unregister_listener
      logger.info( "register_listener")

      return if !@enable

      @socket_manager.remove_listener( @device, self)

      return
    end


    def recv_message( name, message)
      logger.info( "recv_message( name, message)")

      return if message.nil?

      result = handle_message( name, message)

      if result 
        logger.log( "sending greeting message to #{message.message_recipient}")
        @socket_manager.send_message( @device, result)
      end
        
      return
    end

    
    def handle_message( name, message)
      logger.info( "handle_message( name, message)")

      return if message.nil?

      return if !message.is_local?

      user_call = APRSCall.parse( message.source)

      # return if user_call is invalid
      return if user_call.nil?

      now = Time.now

      # return if user_call already exists
      return if @user_calls.has_key?( user_call.to_s) && @user_calls[user_call.to_s] + @timeout > now

      # expire user_calls
      @user_calls.each{ |key, value|
        if value + @timeout < now
          @user_calls.delete( key)
        end
      }

      # add user_call and send greeting message
      @user_calls[user_call.to_s] = Time.now

      user_message = @message.clone
      user_payload = user_message.payload

      user_message.message_recipient = user_call.to_s
      user_message.message_payload = eval( "\"#{user_payload}\"") if user_payload
        
      return user_message
    end

  end

end
