#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'
require 'aprs4r/PluginConfiguration'


module APRS4R

  class GatewayPluginConfiguration < PluginConfiguration

    attr_accessor :call, :inDevice, :outDevice, :localOnly, :replacePath, :path


    def initialize( call = nil, inDevice = nil, outDevice = nil, localOnly = false, replacePath = false, path = Array.new)

      @call = call

      @inDevice = inDevice
      @outDevice = outDevice

      @localOnly = localOnly

      @replacePath = replacePath
      @path = path

      return
    end


    def attributes
      
      attributes = [ 
                    ConfigurationAttribute.new( "call",        "text",    true, 10, "MYCALL-10", "Gateway-Rufzeichen"),
                    ConfigurationAttribute.new( "inDevice",    "text",    true, 10, "rf0", "Empfangsschnittstelle"),
                    ConfigurationAttribute.new( "outDevice",   "text",    true, 10, "is0", "Sendeschnittstelle"),
                    ConfigurationAttribute.new( "localOnly",   "boolean", true, 10, false, "nur lokale Stationen (optional)"),
                    ConfigurationAttribute.new( "replacePath", "boolean", true, 10, false, "Pfadersetzung (optional)"),
                    ConfigurationAttribute.new( "path",        "array",   true, 20, nil,   "Pfad (optional)")
                   ]

      return super + attributes
    end


    def to_yaml_properties
      return super + %w{@call @inDevice @outDevice @localOnly @replacePath @path}
    end

  end

end
