#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2009 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'


module APRS4R

  class APRSPath < APRS4RBase

    include Comparable

    attr_accessor :calls

    @logger = APRS4RLogger.get_logger( "APRSPath")


    def initialize( calls = Array.new)
      logger.info( "initialize( calls)")

      @calls = calls

      return
    end


    def <=>( other)
      logger.info( "<=>( other)")

      return @calls <=> other.calls
    end


    def to_s
      logger.info( "to_s")

      buffer = String.new

      @calls.each{ |call|
        buffer << call.to_s << ","
      }

      return buffer.chop!
    end


    def APRSPath.has_NOGATE?( value)
      logger.info( "has_NOGATE?( value)")

      return APRSPath.has_call?( value, "NOGATE")
    end


    def APRSPath.has_RFONLY?( value)
      logger.info( "has_RFONLY?( value)")

      return APRSPath.has_call?( value, "RFONLY")
    end

    
    def APRSPath.has_call?( value, call)
      logger.info( "has_call?( value, call)")

      return false if value.nil?
      return false if !value.is_a?( Array)

      return value.include?( call.to_s)
    end


    def APRSPath.parse( value)
      logger.info( "parse( value)")

      # FIXME add parser code

      return APRSPath.clone( value)
    end


    def APRSPath.append_call( value, call)
      logger.info( "APRSPath.append_call( value, call)")

      return if value.nil? || call.nil?
      return if !value.is_a?( Array)

      value << call.to_s
      
      return
    end

    
    def APRSPath.append_path( value, path)
      logger.info( "APRSPath.append_path( value, path)")

      return if value.nil? || path.nil?
      return if !value.is_a?( Array) || !value.is_a?( Array)
      
      value.concat( path)

      return
    end

    
    def APRSPath.clone( value)
      logger.info( "APRSPath.clone( value)")

      return nil if value.nil?
      return nil if !value.is_a?( Array)

      # FIXME deep copy needed ?
      return value.clone
    end


  end

end
