#!/bin/sh

echo "APRS4R installation script (minimal setup)"

APRS4R_REPOSITORY_NAME=aprs4r
APRS4R_REPOSITORY_URL=http://www.aprs4r.org/openwrt/kamikaze

IPKG=/usr/bin/ipkg
IPKG_CONF=/etc/ipkg.conf

OPKG=/bin/opkg
OPKG_CONF=/etc/opkg.conf

PKG=/bin/false
PKG_CONF=/dev/null

echo ""
echo "Looking for package manager..."
echo ""

if [ -x $IPKG ]; then
	echo "$IPKG found..."
	PKG=$IPKG
	PKG_CONF=$IPKG_CONF
elif [ -x $OPKG ]; then 
	echo "$OPKG found..."
	PKG=$OPKG
	PKG_CONF=$OPKG_CONF
else 
	echo "no package manager found..."
	exit 1
fi

echo ""
echo "Updating package descriptions..."
echo ""
$PKG update

echo "Installing ruby core packages..."
echo ""
$PKG install ruby ruby-core ruby-yaml

echo ""
echo "Looking for aprs4r repository..."
echo ""
cat $PKG_CONF | grep -q "$APRS4R_REPOSITORY_URL"

if [ "$?" != "0" ]; then
    echo "Adding aprs4r repository..."
    echo "src $APRS4R_REPOSITORY_NAME $APRS4R_REPOSITORY_URL" >> $PKG_CONF

    echo "Updating package descriptions..."
    $PKG update
fi

echo ""
echo "Installing ruby lib packages..."
echo ""
$PKG install ruby-serialport ruby-log4r

echo ""
echo "Installing aprs4r software (excluding web interface)"
echo ""
$PKG install aprs4r 

echo ""
echo "Installation (hopefully) complete..."
echo ""

