#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2009 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"
print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'
APRS4R::APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/APRSMessage'
require 'aprs4r/GreetingPlugin'
require 'aprs4r/GreetingPluginConfiguration'


module APRS4R

  class GreetingPluginTest < Test::Unit::TestCase

    @@logger = APRS4RLogger.get_logger( "GreetingPluginTest")

    
    def setup
      configuration = GreetingPluginConfiguration.new
      configuration.device = "test0"
      configuration.timeout = 3

      message = APRSMessage.new( "STATION", "TO", ["WIDE2-1"], "Hallo \#{user_call}, willkommen zum Treffen")
                                 
      configuration.message = message

      @plugin = GreetingPlugin.new
      @plugin.setup( configuration)

      return
    end


    def test_nil_message
      
      message = nil

      result = @plugin.handle_message( "test0", message)

      assert_nil( result)

      return
    end


    def test_nil_source
      
      message = APRSMessage.new( nil, "TO", [], "")

      result = @plugin.handle_message( "test0", message)

      assert_nil( result)

      return
    end


    def test_send_greeting

      message = APRSMessage.new( "CALL1-5", "TO", [], "message")

      result = @plugin.handle_message( "test0", message)
      assert_not_nil( result)
      assert_instance_of( APRSMessage, result)
      @@logger.debug( "message: #{result}")

      return
    end
      

    def test_prior_greeting

      message1 = APRSMessage.new( "CALL1-5", "TO", [], "message1")
      message2 = APRSMessage.new( "CALL1-5", "TO", [], "message2")

      result1 = @plugin.handle_message( "test0", message1)
      assert_not_nil( result1)
      assert_instance_of( APRSMessage, result1)

      sleep 1

      result2 = @plugin.handle_message( "test0", message2)
      assert_nil( result2)

      return
    end
      

    def test_timeout

      message1 = APRSMessage.new( "CALL1-5", "TO", [], "message1")
      message2 = APRSMessage.new( "CALL1-5", "TO", [], "message2")

      result1 = @plugin.handle_message( "test0", message1)
      assert_not_nil( result1)
      assert_instance_of( APRSMessage, result1)

      sleep 5

      result2 = @plugin.handle_message( "test0", message2)
      assert_not_nil( result2)
      assert_instance_of( APRSMessage, result2)

      return
    end

    
    def test_local
      message = APRSMessage.new( "CALL1-5", "TO", ["WIDE2-1"], "message")

      result = @plugin.handle_message( "test0", message)
      assert_not_nil( result)
      assert_instance_of( APRSMessage, result)
      @@logger.debug( "message: #{result}")

      return
    end


    def test_remote
      message = APRSMessage.new( "CALL1-5", "TO", ["DIGI1*", "WIDE2-1"], "message")

      result = @plugin.handle_message( "test0", message)
      assert_nil( result)

      return
    end
  end

end

