#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "#{default_path}/log4r.yaml"

print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'
include APRS4R

APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/APRS4RConfiguration'


module APRS4R

  class APRS4RConfigurationTest < Test::Unit::TestCase

    @@logger = APRS4RLogger.get_logger( "APRS4RConfigurationTest")

    
    def setup
      @configuration = APRS4RConfiguration.loadConfiguration( "etc/aprs4r/local.yaml")
    end
    
    
    def test_list_empty
      @@logger.info( "list_empty")

      result = @configuration.list
      @@logger.debug( "result: \n#{result.join( "\n")}")
      assert_equal( result.length, 2)

      result = @configuration.list( nil)
      @@logger.debug( "result: \n#{result.join( "\n")}")
      assert_equal( result.length, 2)
      
      result = @configuration.list( "")
      @@logger.debug( "result: \n#{result.join( "\n")}")
      assert_equal( result.length, 2)
      
      return
    end


    def test_list_devices
      @@logger.info( "list_devices")

      result = @configuration.list( "devices")
      @@logger.debug( "result: \n#{result.join( "\n")}")
      assert_equal( result.length, 1)

    end


    def test_list_plugins
      @@logger.info( "list_plugins")

      result = @configuration.list( "plugins")
      @@logger.debug( "result: \n#{result.join( "\n")}")
      assert_equal( result.length, 3)

    end


    def test_list_device
      @@logger.info( "list_device")

      result = @configuration.list( "devices/device1")
      @@logger.debug( "result: \n#{result.join( "\n")}")
      assert_equal( result.length, 9)
    end


    def test_get_device_scalar
      @@logger.info( "get_device_scalar")

      result = @configuration.get( "devices/device1/port")
      @@logger.debug( "result: #{result}")

      assert_equal( result.length, 1)
      assert_equal( result[0], 14580)
      
    end


    def test_get_device_array
      @@logger.info( "get_device_array")

      result = @configuration.get( "devices/device1/hosts")
      @@logger.debug( "result: #{result}")
      assert_equal( result.length, 1)
      assert_equal( result[0], ["germany.aprs2.net", "dl.aprs2.net"])
      
    end


    def test_list_plugin
      @@logger.info( "list_plugin")

      result = @configuration.list( "plugins/plugin1")
      @@logger.debug( "result: \n#{result.join( "\n")}")
      # assert_equal( result.length, 9)
    end

    
    def test_get_plugin_scalar
      @@logger.info( "get_plugin_scalar")

      result = @configuration.get( "plugins/plugin1/message/source")
      @@logger.debug( "result: #{result}")
      assert_equal( result.length, 1)
      assert_equal( result[0], "DO5MC-15")
      
    end


    def test_get_plugin_array
      @@logger.info( "get_plugin_array")

      result = @configuration.get( "plugins/plugin1/message/path")
      @@logger.debug( "result: #{result}")
      assert_equal( result.length, 1)
      assert_equal( result[0], [])
      
    end


    def test_set_plugin_scalar
      @@logger.info( "set_plugin_scalar")

      result = @configuration.get( "plugins/plugin1/message/source")
      @@logger.debug( "result: #{result}")

      @configuration.set( "plugins/plugin1/message/source", "HALLO")
      
      result = @configuration.get( "plugins/plugin1/message/source")
      @@logger.debug( "result: #{result}")

    end

  end

end
  
