#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2010 by Michael Conrad <do5mc@aprs4r.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"

print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'

APRS4R::APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/APRSMessage'
require 'aprs4r/server/filter/AreaFilter'


module APRS4R 

  class AreaFilterTest < Test::Unit::TestCase

    @@logger = APRS4RLogger.get_logger( "AreaFilterTest")

    def test_nil_message
      
      filter = AreaFilter.new( 45, 45, -45, -45)

      message = nil
      result = filter.match( message)
      assert( !result)
    end


    def test_positionless_message
     
      filter = AreaFilter.new( 45, 45, -45, -45)

      message = APRSMessage.new( "FROM", "TO", [], ">Status")
      result = filter.match( message)
      assert( !result)
    end
  end

end
