#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/Plugin'
require 'aprs4r/APRSCall'
require 'aprs4r/BeaconPluginConfiguration'


module APRS4R

  class BeaconPlugin < Plugin

    @logger = APRS4RLogger.get_logger( "BeaconPlugin")

    attr_reader :device, :period, :offset, :message
    

    def initialize
      logger.info( "initialize")

      super

      @thread = nil
      @thread_run = false
      @thread_mutex = Mutex.new

      return
    end

    
    def setup( configuration)
      logger.info( "setup( configuration")

      super( configuration)
      
      @device = configuration.device
      @period = configuration.period
      @offset = configuration.offset
      
      @message = configuration.message if configuration.message
      @message.payload = "" if @message.payload.nil?

      if @message.source =~ /^MYCALL/i
        raise "BeaconPlugin: plugin: #{@name}, invalid message call: #{@message.source}, please use valid call"
      end

      return
    end


    def start
      logger.info( "start")

      return if !@enable

      @thread_run = true
      @thread = Thread.new { run } 

      return
    end

    
    def stop
      logger.info( "stop")

      return if !@enable

      @thread_run = false

      @thread_mutex.synchronize do 
        @thread.run

        while @thread.status != false && @thread.status != nil
          sleep 1
          @thread.run 
        end
      end

      return
    end
    

    def run
      logger.info( "run")

      sleep @offset

      while @thread_run

        @thread_mutex.synchronize do 
          message = create_beacon

          if message
            logger.log( "sending beacon on device #{@device}: #{message}")
            @socket_manager.send_message( @device, message)
            
            # attention: use this call with caution
            @socket_manager.send_local_message( @device, message)
          end

        end

        sleep @period
      end
      
      return
    end


    def create_beacon
      logger.info( "create_beacon")
      
      return @message
    end

  end

end
