#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"

print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'

APRS4R::APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/APRSMessage'
require 'aprs4r/BuddyGatewayPlugin'
require 'aprs4r/BuddyGatewayPluginConfiguration'


module APRS4R 
  class BuddyGatewayPluginTest < Test::Unit::TestCase
    
    
    def test_no_filter
      message = APRSMessage.new( "FROM", "TO", [], ">gateway test")
      
      configuration = GatewayPluginConfiguration.new( "in0", "out0", nil)
      plugin = GatewayPlugin.new( configuration)
      
      
      result = plugin.handle_message( "in0", message)
      assert_nil( result)
      
      return
    end
    

    def test_all_filter
      message = APRSMessage.new( "FROM", "TO", [], ">buddy gateway test")
      
      configuration = GatewayPluginConfiguration.new( "in0", "out0", ["*"])
      plugin = GatewayPlugin.new( configuration)
      
      
      result = plugin.handle_message( "in0", message)
      assert( result)
      
      return
    end


    def test_buddy_filter
      message1 = APRSMessage.new( "HIT", "TO", [], ">buddy gateway test")
      message2 = APRSMessage.new( "MISS", "TO", [], ">buddy gateway test")
      
      configuration = GatewayPluginConfiguration.new( "in0", "out0", ["HIT"])
      plugin = GatewayPlugin.new( configuration)
      
      
      result1 = plugin.handle_message( "in0", message1)
      assert( result1)

      result2 = plugin.handle_message( "in0", message2)
      assert_nil( result2)
      
      return
    end


    def test_buddies_filter
      message1 = APRSMessage.new( "BUDDY1", "TO", [], ">buddy gateway test")
      message2 = APRSMessage.new( "BUDDY2", "TO", [], ">buddy gateway test")
      message3 = APRSMessage.new( "BUDDY3", "TO", [], ">buddy gateway test")
      
      configuration = GatewayPluginConfiguration.new( "in0", "out0", ["BUDDY1", "BUDDY2"])
      plugin = GatewayPlugin.new( configuration)
      
      
      result1 = plugin.handle_message( "in0", message1)
      assert( result1)

      result2 = plugin.handle_message( "in0", message2)
      assert( result2)
      
      result3 = plugin.handle_message( "in0", message3)
      assert_nil( result3)
      
      return
    end


    def test_ssid_filter
      message1 = APRSMessage.new( "BUDDY1-1", "TO", [], ">buddy gateway test")
      message2 = APRSMessage.new( "BUDDY1-5", "TO", [], ">buddy gateway test")
      message3 = APRSMessage.new( "BUDDY2-2", "TO", [], ">buddy gateway test")
      
      configuration = GatewayPluginConfiguration.new( "in0", "out0", ["BUDDY1*"])
      plugin = GatewayPlugin.new( configuration)
      
      
      result1 = plugin.handle_message( "in0", message1)
      assert( result1)

      result2 = plugin.handle_message( "in0", message2)
      assert( result2)
      
      result3 = plugin.handle_message( "in0", message3)
      assert_nil( result3)
      
      return
    end

  end

end
  
