#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'
require 'aprs4r/PluginConfiguration'


module APRS4R

  class XMLDataPluginConfiguration < PluginConfiguration

    attr_reader :file, :device, :call, :latitude, :longitude, :period, :timeout, :filter
    attr_writer :file, :device, :call, :latitude, :longitude, :period, :timeout, :filter

    def to_yaml_properties
      return super + %w{@file @device @call @latitude @longitude @period @timeout @filter}
    end

    def attributes
      
      attributes = [ 
                    ConfigurationAttribute.new( "file",      "text",   true, 20, "/var/log/aprs4r/data-rf0.log",  "Exportdatei"),
                    ConfigurationAttribute.new( "device",    "text",   true, 10, "rf0",  "Schnittstelle"),
                    ConfigurationAttribute.new( "call",      "text",   true, 10, "MYCALL",  "Rufzeichen"),
                    ConfigurationAttribute.new( "latitude",  "float",  true,  8, 49.000,  "Breite"),
                    ConfigurationAttribute.new( "longitude", "float",  true,  8, 8.2500,  "Lnge"),
                    ConfigurationAttribute.new( "period",    "number", true,  6, 300,  "Exportinterval"),
                    ConfigurationAttribute.new( "timeout",   "number", true,  6, 2000,  "Stationstimeout"),
                    ConfigurationAttribute.new( "filter",    "text",   true, 10, "",  "Exportfilter")
                   ]

      return super + attributes
    end

  end

end
