#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'
require 'aprs4r/WeatherPluginConfiguration'


module APRS4R

  class WMRWeatherPluginConfiguration < WeatherPluginConfiguration

    attr_reader :file, :device, :period, :offset, :message
    attr_writer :file, :device, :period, :offset, :message


    def to_yaml_properties
      return super + %w{ @file @device @period @offset @message}
    end


    def attributes
      
      attributes = [ 
                    ConfigurationAttribute.new( "file",  "text", true, 20, "/dev/usb/tts/1", "USB-Schnittstelle"),
                    ConfigurationAttribute.new( "device",  "text",    true, 10, "is0", "Schnittstelle"),
                    ConfigurationAttribute.new( "period",  "number",  true,  6, 600, "Intervall"),
                    ConfigurationAttribute.new( "offset",  "number",  true,  6, 0, "Offset"),
                    ConfigurationAttribute.new( "message", "complex", true, 20, APRSMessage.new, "Message")
                   ]

      return super + attributes
    end

  end

end
