#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'thread'

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'

require 'aprs4r/SocketConfiguration'


module APRS4R

  class Socket < APRS4RBase

    attr_reader :name, :type, :enable, :duplicatePeriod
    
    @logger = APRS4RLogger.get_logger( "Socket")
    
    
    def initialize( configuration = nil)
      logger.info( "initialize( configuration)")
      
      @mutex = Mutex.new
      @initialized = false
      
      @name = nil
      @type = nil
      @enable = false
      @duplicatePeriod = nil
      
      if configuration 
        @name = configuration.name 
        @type = configuration.type 
        @enable = configuration.enable 
        @duplicatePeriod = configuration.duplicatePeriod 
      end
      
      return
    end
    
    
    def delayed_initialize
      logger.info( "delayed_initialize")
      
      # delayed initialisation to avoid blocking of main thread
      @mutex.synchronize do
        if !@initialized
          initSocket
          
          @initialized = true 
        end
      end
      
      return
    end
    
  end

end

