#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/GatewayPluginConfiguration'
require 'aprs4r/Plugin'
require 'aprs4r/SocketManager'


module APRS4R

  class GatewayPlugin < Plugin

    @logger = APRS4RLogger.get_logger( "BuddyGatewayPlugin")


    def initialize( configuration)
      logger.info( "initialize( configuration)")

      super( configuration)

      @inDevice = configuration.inDevice
      @outDevice = configuration.outDevice

      @filter = nil
      @filter = configuration.filter if configuration.filter

      @path = []
      @path = configuration.path if configuration.path

      # replace wildcard with regexp
      @filter.each_index{ |index|
        if @filter[index] =~ /\*$/
          @filter[index] = /#{@filter[index].gsub( /\*/, ".*")}/ 
        else
          @filter[index] = /#{@filter[index]}/
        end
                                                                   
      }

      return
    end


    def registerListener
      logger.info( "registerListener")

      if @enable
        SocketManager.addListener( @inDevice, self)
      end

      return
    end


    def unregisterListener
      logger.info( "registerListener")

      if @enable
        SocketManager.removeListener( @inDevice, self)
      end

      return
    end


    def start
      logger.info( "start")

      if ! @enable 
        return
      end

      registerListener

      return
    end

    
    def receiveAPRSMessage( name, message)
      logger.info( "receiveAPRSMessage( name, message)")
      
      if message.nil?
        logger.warn( "message: nil\n")
        return
      end
      
      result = handle_message( name, message)
      
      if result
        logger.warn( "gating from #{name} to #{@outDevice}, message: #{result}")
        SocketManager.sendAPRSMessage( @outDevice, result)
      end
      
      return
    end
  
  
    def handle_message( name, message)
      logger.info( "handle_gateway( name, message)")
      
      # NOGATE check
      path = message.path
      if path.nil? || path.include?( "NOGATE") || path.include?( "RFONLY")
        return
      end
      
      # filter check
      if @filter.nil? || @filter.empty?
        return
      end

      @filter.each{ |filter|
        if message.source =~ filter 
          message.path = @path
          return message
        end
      }
      
      return
    end

  end

end
