#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'yaml'

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSCall'
require 'aprs4r/APRSMessage'
require 'aprs4r/SocketConfiguration'
require 'aprs4r/ISSocketConfiguration'
require 'aprs4r/AX25SocketConfiguration'

require 'aprs4r/PluginConfiguration'
require 'aprs4r/BeaconPluginConfiguration'
require 'aprs4r/ProportionalBeaconPluginConfiguration'
require 'aprs4r/GatewayPluginConfiguration'
require 'aprs4r/DigipeaterPluginConfiguration'
require 'aprs4r/LCD4LinuxPluginConfiguration'
require 'aprs4r/XMLDataPluginConfiguration'
require 'aprs4r/QueryPluginConfiguration'
require 'aprs4r/MessagePluginConfiguration'
require 'aprs4r/ISServerPluginConfiguration'
require 'aprs4r/WeatherPluginConfiguration'
require 'aprs4r/WMRWeatherPluginConfiguration'
require 'aprs4r/WS2300WeatherPluginConfiguration'
require 'aprs4r/LogPluginConfiguration'


module APRS4R 

  class APRS4RConfiguration < APRS4RBase

    attr_reader :devices, :plugins
    attr_writer :devices, :plugins

    @logger = APRS4RLogger.get_logger( "APRS4RConfiguration")


    def initialize
      logger.info( "initialize()")

      @devices = Hash.new
      @plugins = Hash.new

      return
    end


    def APRS4RConfiguration.getConfiguration()
      logger.info( "getConfiguration()")

      return @@configuration 
    end


    def APRS4RConfiguration.setConfiguration( configuration)
      logger.info( "setConfiguration( configuration)")

      @@configuration = configuration

      return
    end


    def APRS4RConfiguration.loadConfiguration( name) 
      logger.info( "loadConfiguration( name)")

      configuration = nil

      begin
        configuration = YAML.load_file( name)
      rescue Exception => ex
        logger.error( "Error reading file: #{name}")
      end

      if configuration.nil? || configuration == false
        configuration = APRS4RConfiguration.new
      end
        
      return configuration
    end


    def APRS4RConfiguration.saveConfiguration( name, configuration)
      logger.info( "saveConfiguration( name, configuration)")

      begin 
        File.open( name, "w") { |file|
          YAML.dump( configuration, file)
        }
      rescue Exception => ex
        logger.error( "Error writing file: #{name}")
      end

      return
    end


    def to_yaml_properties
      return %w{@devices @plugins}
    end

  end

end
