#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/Plugin'
require 'aprs4r/StatusPluginConfiguration'
require 'aprs4r/SocketManager'


module APRS4R

  class StatusPlugin < Plugin

    @logger = APRS4RLogger.get_logger( "StatusPlugin")

    
    def initialize( configuration)
      logger.info( "initialize( configuration)")

      super( configuration)

      @port = 1234 
      @port = configuration.port if configuration.port

      return
    end

    
    def start
      logger.info( "start")

      if ! @enable
        return
      end
      
      # start tcp server
      Thread.new { 
        run
      }
      
      return
    end


    def run
      logger.info( "run")

      server = TCPServer.open( @port)

      loop do 
        socket = server.accept
        
        command = socket.gets
        command.chomp! if command

        case command
          when "line1"
          socket.puts( sprintf( "APRS4R-%5s", APRS4R::APRS4RVersion))
          when "line2"
          socket.puts( sprintf( "%3.3s in %4.4s out %4.4s", "rf0", SocketManager.recv_count( "rf0"), SocketManager.send_count( "rf0")))
          when "line3"
          socket.puts( sprintf( "%3.3s in %4.4s out %4.4s", "is0", SocketManager.recv_count( "is0"), SocketManager.send_count( "is0")))

          when "line4"
          socket.puts( SocketManager.lastMessage)
          else
          socket.puts( "unknown query")
        end

        socket.close
      end

      return
    end
    
  end

end
