#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/SocketConfiguration'
require 'aprs4r/ConfigurationAttribute'


module APRS4R

  class ISSocketConfiguration < SocketConfiguration

    attr_reader :hosts, :port, :username, :filter, :duplicatePeriod, :timeout
    attr_writer :hosts, :port, :username, :filter, :duplicatePeriod, :timeout


    def to_yaml_properties
      super + %w{@hosts @port @username @filter @duplicatePeriod @timeout}
    end


    def attributes
      attributes = [
                    ConfigurationAttribute.new( "hosts",           "array",  true, 30, ["germany.aprs2.net", "dl.aprs2.net"], "Hostname"),
                    ConfigurationAttribute.new( "port",            "number", true,  6, 14580,             "Portnummer"),
                    ConfigurationAttribute.new( "username",        "text",   true, 10, "MYCALL",               "Benutzer"),
                    ConfigurationAttribute.new( "filter",          "text",   true, 20, "# filter m/50",   "Filter"),
                    ConfigurationAttribute.new( "duplicatePeriod", "number", true, 10, 15,         "Duplikatsinterval"),
                    ConfigurationAttribute.new( "timeout",         "number", true,  6, 300,               "Timeout")
                   ]

      return super + attributes 
    end

  end

end
