#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/SocketConfiguration'
require 'aprs4r/ConfigurationAttribute'


module APRS4R

  class AX25SocketConfiguration < SocketConfiguration

    attr_reader :call, :device, :baudrate, :mode, :speed, :duplicatePeriod, :timeout
    attr_writer :call, :device, :baudrate, :mode, :speed, :duplicatePeriod, :timeout


    def to_yaml_properties
      super + %w{@call @device @baudrate @mode @speed @duplicatePeriod @timeout}
    end


    def attributes
      attributes = [
                    ConfigurationAttribute.new( "call",            "text",   true, 10, "MYCALL",              "Rufzeichen"),
                    ConfigurationAttribute.new( "device",          "text",   true, 10, "/dev/usb/tts/0",      "Gert"),
                    ConfigurationAttribute.new( "baudrate",        "number", true,  6, 9600,                  "Baudrate"),
                    ConfigurationAttribute.new( "mode",            "text",   true, 15, "kiss/tnc2/northlink", "Modus"),
                    ConfigurationAttribute.new( "speed",           "number", true,  6, 1200,                  "Geschwindigkeit"),
                    ConfigurationAttribute.new( "duplicatePeriod", "number", true, 10, 15,                    "Duplikatsinterval"),
                    ConfigurationAttribute.new( "timeout",         "number", true,  6, 300,                   "Timeout")
                   ]

      return super + attributes
    end

  end

end
