#!/bin/sh

APRS4R_REPOSITORY_NAME=aprs4r
APRS4R_REPOSITORY_URL=http://afu.friggleware.de/openwrt/kamikaze

IPKG=/usr/bin/ipkg

echo "Updating package descriptions..."
$IPKG update

echo "Installing kernen usb modules..."
$IPKG install kmod-usb-core kmod-usb-uhci kmod-usb2

echo "Installing kernel usb serial modules..."
$IPKG install kmod-usb-serial-pl2303 kmod-usb-serial-ftdi kmod-usb-serial-belkin

echo "Installing ruby packages..."
$IPKG install ruby ruby-core ruby-yaml ruby-cgi ruby-webrick


echo "Checking for aprs4r ipkg repository..."
cat /etc/ipkg.conf | grep -q "$APRS4R_REPOSITORY_URL"

if [ "$?" != "0" ]; then
    echo "Adding aprs4r ipkg repository..."
    echo "src $APRS4R_REPOSITORY_NAME $APRS4R_REPOSITORY_URL" >> /etc/ipkg.conf

    echo "Updating package descriptions..."
    $IPKG update
fi

echo "Installing aprs4r software..."
$IPKG install aprs4r 

echo "Installing aprs4r-web software..."
$IPKG install aprs4r-web

exit 0
