#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'thread'

require 'aprs4r/APRS4RBase'
require 'aprs4r/APRS4RLogger'


module APRS4R

  class SocketRecvThread < APRS4RBase

    @logger = APRS4RLogger.get_logger( "SocketRecvThread");

    @@QUEUE_MAX_LENGTH = 10


    def initialize( socket)
      logger.info( "initialize( socket)")

      @socket = socket
      @name = socket.name
      @enable = socket.enable

      @queue = Queue.new

      return
    end


    def recvAPRSMessage
      logger.info( "recvAPRSMessage")

      return @queue.pop
    end


    def run
      logger.info( "run")
      
      if !@enable 
        return
      end

      @socket.delayed_initialize

      while true
        
        # wait for message
        message = @socket.readAPRSMessage

        if message 
          logger.log( "message recv on #{@name}: #{message}")
          # queue message in recv queue
          @queue.push( message)

          # remove first queue element if queue is full
          if @queue.length > @@QUEUE_MAX_LENGTH
            begin 
              @queue.pop( true)
            rescue Exception 
            end
          end
        end

      end

      return
    end

  end

end
